# SmartHotel Agent API Server
## Domain: api.smarthotelagent.com

This directory contains all backend API services and Supabase Edge Functions for the SmartHotel Agent platform.

## 📁 Directory Structure

```
api/
├── supabase/
│   ├── functions/
│   │   ├── ai-concierge-v2/        # AI chatbot backend
│   │   ├── check-config/           # Configuration checker
│   │   ├── migrate-opera/          # Opera PMS migration
│   │   ├── migrate-mews/           # Mews PMS migration
│   │   └── migrate-cloudbeds/      # Cloudbeds PMS migration
│   └── migrations/
│       ├── create_hotels_table.sql
│       └── create_ai_messages_table.sql
└── README.md
```

## 🚀 Deployment Instructions

### Prerequisites

1. **Supabase CLI installed**
```bash
npm install -g supabase
```

2. **Supabase project configured**
- Project URL: https://gvihjfbtzffxesayjxou.supabase.co
- Project REF: gvihjfbtzffxesayjxou

### Deploy Edge Functions

```bash
# Login to Supabase
supabase login

# Link your project
supabase link --project-ref gvihjfbtzffxesayjxou

# Deploy all functions
cd supabase/functions
supabase functions deploy ai-concierge-v2
supabase functions deploy check-config
supabase functions deploy migrate-opera
supabase functions deploy migrate-mews
supabase functions deploy migrate-cloudbeds
```

### Create Database Tables

Run the SQL migration scripts in your Supabase SQL Editor:

1. **Hotels Table**
```sql
-- Run: supabase/migrations/create_hotels_table.sql
```

2. **AI Messages Table**
```sql
-- Run: supabase/migrations/create_ai_messages_table.sql
```

## 🔧 Environment Variables

Set these environment variables in your Supabase project:

### Required for All Functions
- `SUPABASE_URL` - Automatically available
- `SUPABASE_SERVICE_ROLE_KEY` - Automatically available

### AI Concierge
- `OPENAI_API_KEY` - Your OpenAI API key (configured per hotel)

### PMS Migration
- Opera: No additional env vars needed (credentials from request)
- Mews: No additional env vars needed (credentials from request)
- Cloudbeds: No additional env vars needed (credentials from request)

## 📡 API Endpoints

Once deployed, your functions will be available at:

```
https://api.smarthotelagent.com/ai-concierge-v2
https://api.smarthotelagent.com/check-config
https://api.smarthotelagent.com/migrate-opera
https://api.smarthotelagent.com/migrate-mews
https://api.smarthotelagent.com/migrate-cloudbeds
```

## 🔐 CORS Configuration

All functions are configured to accept requests from:
- `https://core.smarthotelagent.com`
- `https://updates.smarthotelagent.com`

## 📊 Function Details

### 1. AI Concierge V2
- **Path**: `/ai-concierge-v2`
- **Method**: POST
- **Purpose**: AI chatbot with conversation memory
- **Features**: OpenAI integration, session tracking, context retention

### 2. Check Config
- **Path**: `/check-config`
- **Method**: POST
- **Purpose**: Verify hotel configuration (API keys, settings)

### 3. Migrate Opera
- **Path**: `/migrate-opera`
- **Method**: POST
- **Purpose**: Import data from Opera PMS
- **Supports**: Rooms, reservations, guests

### 4. Migrate Mews
- **Path**: `/migrate-mews`
- **Method**: POST
- **Purpose**: Import data from Mews PMS
- **Supports**: Rooms, reservations, guests

### 5. Migrate Cloudbeds
- **Path**: `/migrate-cloudbeds`
- **Method**: POST
- **Purpose**: Import data from Cloudbeds PMS
- **Supports**: Rooms, reservations, guests

## 🐛 Debugging

View function logs:
```bash
supabase functions logs ai-concierge-v2
supabase functions logs migrate-opera
```

## 🔄 Updates

To update a function:
```bash
cd supabase/functions
supabase functions deploy <function-name>
```

## 📞 Support

For API issues:
1. Check function logs in Supabase dashboard
2. Verify environment variables are set
3. Test endpoints with curl or Postman
4. Review CORS settings

## 🎯 Testing

Test an endpoint:
```bash
curl -X POST https://api.smarthotelagent.com/check-config \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer YOUR_ANON_KEY" \
  -d '{"hotel_id": "test_hotel"}'
```